      PROGRAM BEZIER
      INCLUDE 'phigsdef.f'
      
C     Program za izraun vrednosti tok Bezier-jevih krivulj 3. stopnje in njihov izris
c     na zaslon v izometrini projekciji
      INTEGER n, i, k, l, zm1(6,256,8), zm2(6,256,8), zg, s, np, im, j
      INTEGER za, ko, jm, m, mk
      DIMENSION Bx(6,0:256,256), By(6,0:256,256), Bex(2000), Bey(2000)
      REAL Tx(6,256,256), Ty(6,256,256), TOC, zgr, sr
      REAL x(19), y(19), z(19)
      REAL xi(19), yi(19) 
      REAL xmin, xmax, ymin, ymax, deltax, deltay, PI, t, dm, px, py
      REAL WindowLimits(4), ViewMappingMatrix(3,3),ox(5),oy(5)
      REAL ksx(3), ksy(3), ViewportLimits(4)/0.0,1.0,0.0,1.0/
      INTEGER wkid, ErrorReturn
      OPEN (1,FILE='podatki.txt')
      OPEN (2,FILE='rezultat.txt')
      open (3,file='rez1.txt')
      open (4,file='rez2.txt')
      
c     Branje podatkov iz datoteke:
c     tevila kontrolnih tok "l" in samih kontrolnih tok "p(x,y,z)"
      READ(1,*) l
      jm=(l-4)/3+1
10    FORMAT(/F12.5//F12.5//F12.5/)      
      DO k=1,l
          READ(1,*) x(k), y(k), z(k)
      ENDDO
      
c     transformacija podanih koordinat v koordinate izometrine projekcije
      PI=3.1415926      
      DO k=1,l
          xi(k)=(x(k)-y(k))*COS(PI/6)
          yi(k)=z(k)+(x(k)+y(k))*SIN(PI/6)
      ENDDO
      
c     izraun razsenosti slike          
      xmin=xi(1)
      xmax=xi(1)
      ymin=yi(1)
      ymax=yi(1)
      DO k=2,l
          IF (xi(k).LT.xmin) xmin=xi(k)
          IF (xi(k).GT.xmax) xmax=xi(k)
          IF (yi(k).LT.ymin) ymin=yi(k)
          IF (yi(k).GT.ymax) ymax=yi(k)
      ENDDO
      deltax=xmax-xmin
      deltay=ymax-ymin
      IF (deltax.GT.deltay) THEN
          dm=1.1*deltax
      ELSE
          dm=1.1*deltay
      ENDIF
      
c     najkraja razdalja med dvema tokama Bezier-jeve krivulje
      px=dx/600
      py=dy/450
      
c     Izraun vrednosti tok Bezier-jeve krivulje:
c     izraun iz 4 podanih kontrolnih tok z razpolavljanjem Bezier-jeve
c     krivulje:
c     -zaetna in konna toka
      DO j=1,jm
          za=3*j-2
          ko=3*j+1
          zg=0
          s=1
          Bx(j,zg,s)=xi(za)
          By(j,zg,s)=yi(za)
          Bx(j,1,1)=xi(ko)
          By(j,1,1)=yi(ko)
          i=1
          im=1
          n=1
          zg=1
          s=2
          zgr=zg
          sr=s
          zm1(j,1,n)=0
          zm2(j,1,n)=0
c     -toke na obmojih, kjer bi bile preblizu skupaj ne raunamo          
20        DO i=1,im
              IF (zm1(j,i,n).LT.zgr.AND.zgr.LT.zm2(j,i,n)) THEN
                  zg=zg+2
                  IF (zg.LE.s) THEN
                      zgr=zg
                      GO TO 20
                  ELSE
                      zg=1
                      n=n+1
                      IF (n.GT.8) THEN
                          GO TO 30
                      ENDIF      
                      s=2**n
                      zgr=zg
                      sr=s
                      GO TO 20
                  ENDIF
              ENDIF          
          ENDDO
c     -parameter
          t=zgr/sr
          Tx(j,zg,s)=TOC(t,xi(3*j-2),xi(3*j-1),xi(3*j),xi(3*j+1))
          Ty(j,zg,s)=TOC(t,yi(3*j-2),yi(3*j-1),yi(3*j),yi(3*j+1))
          IF (((ABS(Tx(j,zg,s)-Bx(j,(zg-1)/2,s/2)).GE.px).AND.
     *       (ABS(Tx(j,zg,s)-Bx(j,(zg+1)/2,s/2)).GE.px)).OR.
     *       ((ABS(Ty(j,zg,s)-By(j,(zg-1)/2,s/2)).GE.py).AND.
     *       (ABS(Ty(j,zg,s)-By(j,(zg+1)/2,s/2)).GE.py))) THEN
c     -vrednosti x in y toke Bezier-jeve krivulje pri polovini vrednosti
c      parametra glede na predhodnji toki
              Bx(j,zg,s)=Tx(j,zg,s)
              By(j,zg,s)=Ty(j,zg,s)
c     -sosednji toki
              Bx(j,zg-1,s)=Bx(j,(zg-1)/2,s/2)      
              By(j,zg-1,s)=By(j,(zg-1)/2,s/2)
              Bx(j,zg+1,s)=Bx(j,(zg+1)/2,s/2)
              By(j,zg+1,s)=By(j,(zg+1)/2,s/2)
              zg=zg+2
              IF (zg.LE.s) THEN
                  zgr=zg
                  GO TO 20
              ELSE
                  zg=1
                  n=n+1
                  IF (n.GT.8) THEN
                      GO TO 30
                  ENDIF      
                  s=2**n
                  zgr=zg
                  sr=s
                  GO TO 20
              ENDIF
c     -neupotevanje tok, ki so si preblizu skupaj
          ELSE
              IF (n.LE.7) THEN
                  np=n
                  s=2**n
                  zm1(j,i,n)=zg-1
                  zm2(j,i,n)=zg+1
                  Bx(j,zg-1,s)=Bx(j,(zg-1)/2,s/2)      
                  By(j,zg-1,s)=By(j,(zg-1)/2,s/2)
                  Bx(j,zg+1,s)=Bx(j,(zg+1)/2,s/2)
                  By(j,zg+1,s)=By(j,(zg+1)/2,s/2)
                  DO n=n+1,8
                      s=2**n
                      zm1(j,i,n)=2*zm1(j,i,n-1)
                      zm2(j,i,n)=2*zm2(j,i,n-1)
                      Bx(j,zm1(j,i,n),s)=Bx(j,zm1(j,i,n)/2,s/2)      
                      By(j,zm1(j,i,n),s)=By(j,zm1(j,i,n)/2,s/2)
                      Bx(j,zm2(j,i,n),s)=Bx(j,zm2(j,i,n)/2,s/2)
                      By(j,zm2(j,i,n),s)=By(j,zm2(j,i,n)/2,s/2)
                  ENDDO
                  n=np
                  s=2**n
              ENDIF
              IF (n.EQ.8) THEN
                  Bx(j,zg-1,s)=Bx(j,(zg-1)/2,s/2)      
                  By(j,zg-1,s)=By(j,(zg-1)/2,s/2)
                  Bx(j,zg+1,s)=Bx(j,(zg+1)/2,s/2)
                  By(j,zg+1,s)=By(j,(zg+1)/2,s/2)
                  zm1(j,i,n)=zg-1
                  zm2(j,i,n)=zg+1
              ENDIF
              im=i
              i=i+1
              zg=zg+2
              IF (zg.LE.s) THEN
                  zgr=zg
                  GO TO 20
              ELSE
                  zg=1
                  n=n+1
                  IF (n.GT.8) THEN
                      GO TO 30
                  ENDIF
                  s=2**n
                  zgr=zg
                  sr=s
                  GO TO 20
              ENDIF
          ENDIF       
30    ENDDO
      
c     Izpis tok za izris krivulje       
      m=1
      DO j=1,jm
          DO zg=0,256
              i=1
35            IF (zm1(j,i,8).LT.zg.AND.zg.LT.zm2(j,i,8)) THEN
                  GO TO 50
              ELSE    
                  i=i+1
                  IF (i.GT.im) THEN
                      GO TO 40
                  ENDIF
                  GO TO 35
              ENDIF
40            write(2,*) Bx(j,zg,256),By(j,zg,256),j,zg,s
              write(3,*) Bx(j,zg,256)
              write(4,*) By(j,zg,256)
              Bex(m)=Bx(j,zg,256)
              Bey(m)=By(j,zg,256)
              m=m+1
50        ENDDO 
      ENDDO
      mk=m-1
      CLOSE (1)
      CLOSE (2)
      CLOSE (3)
      CLOSE (4)
      
c     IZRIS BEZIER-JEVE KRIVULJE V PHIGS-U      
c     Inicializacija grafine knjinice in definicija zaslona
      CALL popph('error.txt',0)
      wkid=1
      CALL popwk(wkid," ",WK171024)
      WindowLimits(1)=(xmin+xmax-dm)/2
      WindowLimits(2)=(xmax+xmin+dm)/2
      WindowLimits(3)=(ymin+ymax-dm)/2
      WindowLimits(4)=(ymax+ymin+dm)/2
      CALL pevmm(WindowLimits,ViewportLimits,ErrorReturn,
     *           ViewMappingMatrix)
c     Nastavitev uporabnikih koordinat
      CALL pswkw(wkid,0.0,1.0,0.0,1.0)
c     Nastavitev zaslonskih koordinat      
      CALL pswkv(wkid,0.0,0.19,0.0,0.19)
c     Nastavitev barve peresa
      CALL psplci(5)
c     Nastavitev debeline peresa
      CALL pslwsc(1.5)
c     Izris koordinatnega sistema izometrine projekcije:
c     -x in y koordinatne osi
      CALL psplci(7)
      ksx(1)=4.5*COS(PI/6)
      ksx(2)=0.0
      ksx(3)=-4.5*COS(PI/6)
      ksy(1)=ksx(1)*TAN(PI/6)
      ksy(2)=0.0
      ksy(3)=ABS(ksx(3))*TAN(PI/6)
      CALL ppl(3,ksx,ksy)          
c     -z koordinatne osi
      ksx(1)=0.0
      ksx(2)=0.0
      ksy(1)=0.0
      ksy(2)=4.5
      CALL ppl(2,ksx,ksy)
c     Oznaka x, y in z osi
      CALL pstxci(7)
      CALL pschh(0.007)
      CALL ptx(4.2,2.0,'x')
      CALL ptx(-4.2,2.0,'y')
      CALL ptx(0.5,4.7,'z')
      CALL ptx(0.1,-0.1,'0')
c     Izris kontrolnih tok
      CALL psplci(4)
      CALL ppl(l,xi,yi)
c     Izris Bezierjeve krivulje
      CALL psplci(3)
      CALL ppl(mk,Bex,Bey)
c     Zaustavitev programa za ogled izrisa
      PAUSE
c     Zapiranje zaslona in knjinice
      CALL pclwk(wkid)                        
      CALL pclph()
      END
      
      
c     Funkcija za izraun koordinat tok bezier-jeve krivulje      
      REAL FUNCTION TOC(u,T1,T2,T3,T4)
      REAL u, T1, T2, T3, T4
      TOC=(T1*(1-u)**3)+(T2*3*u*(1-u)**2)+(T3*3*(1-u)*u**2)+(T4*u**3)
      RETURN
      END
