unit hls2rgbsrc;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Math;

type
  THSV = class(TForm)
    Exit: TButton;
    Panel1: TPanel;
    Image: TImage;
    Button1: TButton;
    MRYG: TButton;
    RYGC: TButton;
    YGCB: TButton;
    GCBM: TButton;
    CBMR: TButton;
    BMRY: TButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    procedure ExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure MRYGClick(Sender: TObject);
    procedure RYGCClick(Sender: TObject);
    procedure YGCBClick(Sender: TObject);
    procedure GCBMClick(Sender: TObject);
    procedure CBMRClick(Sender: TObject);
    procedure BMRYClick(Sender: TObject);
  private
    Bitmap: TBitmap;
    procedure HSV2RGB(H,S,V:Real;var r,g,b:byte);
    procedure HLS2RGB(H,L,S:Real;var C:longword);
    { Private declarations }
  public
    { Public declarations }
  end;

  TC1 = class(TCanvas)
  end;

var
  HSV: THSV;
  C1: TC1;
  Kot: Integer;
implementation

{$R *.DFM}

procedure THSV.ExitClick(Sender: TObject);
begin
  close;
end;

procedure THSV.FormCreate(Sender: TObject);

begin
  Canvas.Create;
  Bitmap := TBitmap.Create;
  Bitmap.Width := Panel1.Width;
  Bitmap.Height := Panel1.Height;
  Image.Picture.Graphic := Bitmap;
  Kot:=30;
  image.canvas.textout(100,20,'Tloris');
  image.canvas.textout(375,20,'Stranski ris');
end;

procedure THSV.HSV2RGB(H,S,V:Real;var r,g,b:byte);
  var f,p,q,t,r1,g1,b1:Extended;
      i:Integer;
  begin
    R:=0;
    G:=0;
    B:=0;
    if (S=0) then
    begin
      R1:=V;
      G1:=V;
      B1:=V;
    end
    else
    begin
      H:=H/60;
      i:=Trunc(H);
      f:=H-i;
      p:=V*(1-S);
      q:=V*(1-(S*f));
      t:=V*(1-(S*(1-f)));
      case i of
        0: begin R1:=V;G1:=t;B1:=p;end;
        1: begin R1:=q;G1:=V;B1:=p;end;
        2: begin R1:=p;G1:=V;B1:=t;end;
        3: begin R1:=p;G1:=q;B1:=V;end;
        4: begin R1:=t;G1:=p;B1:=V;end;
        5: begin R1:=V;G1:=p;B1:=q;end;
      end;
    end;
    r:=trunc(r1*255);
    g:=trunc(g1*255);
    b:=trunc(b1*255);
  end;

procedure THSV.HLS2RGB(H,L,S:Real;var C:longword);
  function RGBx(q1,q2,hue:extended):extended;
  begin
    if hue>360 then hue:=hue-360;
    if hue<0 then hue:=hue+360;
    if hue<60 then RGBx:=q1+(q2-q1)*hue/60
    else
    if hue<180 then RGBx:=q2
    else
    if hue<240 then RGBx:=q1+(q2-q1)*(240-hue)/60
    else
    RGBx:=q1;
  end;

var p1,p2,r1,g1,b1:extended;
    r2,g2,b2:byte;
begin
  if L<=0.5 then p2:=L*(1+S)
  else p2:=L+S-L*S;
  p1:=2*L-p2;
  if S=0 then
  begin
    r1:=L;
    g1:=L;
    b1:=L;
  end
  else
  begin
    r1:=RGBx(p1,p2,H+120);
    g1:=RGBx(p1,p2,H);
    b1:=RGBx(p1,p2,H-120);
  end;
  r2:=trunc(r1*255);
  g2:=trunc(g1*255);
  b2:=trunc(b1*255);
  C:=r2+256*g2+65536*b2;
end;


procedure THSV.Button1Click(Sender: TObject);
var   dx,dx1,dy,dz,x0,y0: Integer;
      H,H1,S,L,L1: Extended;
      col:longword;
      r1,g1,b1:byte;
begin
  x0:=Trunc(Image.Width/2);
  y0:=Trunc(Image.Height/2);
  L:=1;
  H:=0;
  S:=0;

  for dy:=-100 to 100 do
    for dx:=-115 to 115 do
    if (dy<200*(1+dx/115)) and (dy<200*(1-dx/115)) and
       (dy>200*(-1-dx/115)) and (dy>200*(-1+dx/115)) then
    begin
      if (dx=0) then
      begin
        if (dy<0) then H:=270
        else
          H:=90;
      end
      else
        H:=180*arctan2(dy,dx)/Pi;
      if H<0 then H:=H+360;

      S:=sqrt(sqr(dx)+sqr(dy))/115;

      hsv2rgb(h,s,L,r1,g1,b1);
      col:=r1+256*g1+65536*b1;
      image.canvas.pixels[120+dx,y0-dy]:=col;
    end;

  for dy:=0 to 58 do
    for dx:=-58 to 58 do
    if (dy>(-dx)) and (dy>dx) then
    begin
      dz:=round(dy*1.732);
      H:=180*arctan2(dx,dz)/Pi+Kot;
      L:=dy/115;
      S:=sqrt(sqr(dx)+sqr(dz))/115;

      hls2rgb(h,L,s,col);
      image.canvas.pixels[400+dx,210-dy]:=col;

      L1:=1-L;
      hls2rgb(h,L1,s,col);
      image.canvas.pixels[400+dx,95+dy]:=col;


      dx1:=round(dx/2);
      H1:=H+60;
      if H1>360 then H1:=H1-360;
      hls2rgb(h1,L,s,col);
      image.canvas.pixels[400+dx1+round(56*1.5*dy/57.5),210-dy]:=col;

      hls2rgb(h1,L1,s,col);
      image.canvas.pixels[400+dx1+round(56*1.5*dy/57.5),95+dy]:=col;

      H1:=H-60;
      if H1>360 then H1:=H1-360;
      if H1<0 then H1:=H1+360;
      hls2rgb(h1,L,s,col);
      image.canvas.pixels[400+dx1-round(55.5*1.5*dy/57.5),210-dy]:=col;

      hls2rgb(h1,L1,s,col);
      image.canvas.pixels[400+dx1-round(55.5*1.5*dy/57.5),95+dy]:=col;

    end;

end;

procedure THSV.MRYGClick(Sender: TObject);
begin
  Kot:=30;
  RadioButton1.Checked:=True;
  RadioButton2.Checked:=False;
  RadioButton3.Checked:=False;
  RadioButton4.Checked:=False;
  RadioButton5.Checked:=False;
  RadioButton6.Checked:=False;
end;

procedure THSV.RYGCClick(Sender: TObject);
begin
  Kot:=90;
  RadioButton1.Checked:=False;
  RadioButton2.Checked:=True;
  RadioButton3.Checked:=False;
  RadioButton4.Checked:=False;
  RadioButton5.Checked:=False;
  RadioButton6.Checked:=False;
end;

procedure THSV.YGCBClick(Sender: TObject);
begin
  Kot:=150;
  RadioButton1.Checked:=False;
  RadioButton2.Checked:=False;
  RadioButton3.Checked:=True;
  RadioButton4.Checked:=False;
  RadioButton5.Checked:=False;
  RadioButton6.Checked:=False;
end;

procedure THSV.GCBMClick(Sender: TObject);
begin
  Kot:=210;
  RadioButton1.Checked:=False;
  RadioButton2.Checked:=False;
  RadioButton3.Checked:=False;
  RadioButton4.Checked:=True;
  RadioButton5.Checked:=False;
  RadioButton6.Checked:=False;
end;

procedure THSV.CBMRClick(Sender: TObject);
begin
  Kot:=270;
  RadioButton1.Checked:=False;
  RadioButton2.Checked:=False;
  RadioButton3.Checked:=False;
  RadioButton4.Checked:=False;
  RadioButton5.Checked:=True;
  RadioButton6.Checked:=False;
end;

procedure THSV.BMRYClick(Sender: TObject);
begin
  Kot:=330;
  RadioButton1.Checked:=False;
  RadioButton2.Checked:=False;
  RadioButton3.Checked:=False;
  RadioButton4.Checked:=False;
  RadioButton5.Checked:=False;
  RadioButton6.Checked:=True;  
end;

end.
